/*
 * BinaryTree_Interface.h
 *
 * Created 6/8/2009 By Johnny Huynh
 *
 * Version 00.00.01 6/8/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */

 #ifndef BINARYTREE_INTERFACE_H
 #define BINARYTREE_INTERFACE_H
 
 // BinaryTree_Interface shares the properties that are the same among a binary tree and other certain trees.
 template <typename TYPENAME> class BinaryTree_Interface;

 template <typename TYPENAME>
 class BinaryTree_Interface
 {
 // Data Members
 protected:
    TYPENAME* leftChild_Ptr;
	TYPENAME* rightChild_Ptr;

 // Local Functions
 public:
    BinaryTree_Interface();
    BinaryTree_Interface( const BinaryTree_Interface<TYPENAME>& bt );
    ~BinaryTree_Interface();
    inline BinaryTree_Interface<TYPENAME>& operator=( const BinaryTree_Interface<TYPENAME>& bt );
    inline TYPENAME*& leftChild();
    inline TYPENAME*& rightChild();
    inline const TYPENAME* /*const &*/ constLeftChild() const;
    inline const TYPENAME* /*const &*/ constRightChild() const;
    inline bool hasChild() const;
 
 // Private Functions
 private:
 
 // Friend Functions
 public:
 };

 /** LOCAL FUNCTIONS **/

 /**
  * Constructor
  */
 template< typename TYPENAME >
 BinaryTree_Interface<TYPENAME>::BinaryTree_Interface() : leftChild_Ptr( NULL ), rightChild_Ptr( NULL )
 {

 }
 
 /**
  * Alternative Constructor
  */
 template< typename TYPENAME >
 BinaryTree_Interface<TYPENAME>::BinaryTree_Interface( const BinaryTree_Interface<TYPENAME>& bt ) 
                          : leftChild_Ptr( ( bt.constLeftChild() != NULL ? new TYPENAME( *bt.constLeftChild() ) : NULL ) ), 
                            rightChild_Ptr( ( bt.constRightChild() != NULL ? new TYPENAME( *bt.constRightChild() ) : NULL ) )
 {

 }
 
 /**
  * Destructor
  */
 template< typename TYPENAME >
 BinaryTree_Interface<TYPENAME>::~BinaryTree_Interface()
 {
    delete leftChild_Ptr;
    delete rightChild_Ptr;
 }
 
 /**
  * operator=() copies the content of the specified BinaryTree_Interface to this BinaryTree_Interface.
  *
  * @param (const BinaryTree_Interface<TYPENAME>&) bt
  * @return BinaryTree_Interface<TYPENAME>&
  */
 template< typename TYPENAME >
 inline BinaryTree_Interface<TYPENAME>& BinaryTree_Interface<TYPENAME>::operator=( const BinaryTree_Interface<TYPENAME>& bt )
 {
    delete leftChild_Ptr;
    delete rightChild_Ptr;
 
    leftChild_Ptr = ( bt.constLeftChild() != NULL ? new TYPENAME( *bt.constLeftChild() ) : NULL );
    rightChild_Ptr = ( bt.constRightChild() != NULL ? new TYPENAME( *bt.constRightChild() ) : NULL );
    
    return *this;
 }
 
 /**
  * leftChild() returns a reference to the left child pointer in this binary tree interface.
  *
  * @return TYPENAME*&
  */
 template< typename TYPENAME >
 inline TYPENAME*& BinaryTree_Interface<TYPENAME>::leftChild()
 {
    return leftChild_Ptr;
 }
 
 /**
  * rightChild() returns a reference to the right child pointer in this binary tree interface.
  *
  * @return TYPENAME*&
  */
 template< typename TYPENAME >
 inline TYPENAME*& BinaryTree_Interface<TYPENAME>::rightChild()
 {
    return rightChild_Ptr;
 }
 
 /**
  * constLeftChild() returns a constant reference to the left child pointer in this binary tree interface.
  *
  * @return const TYPENAME* const &
  */
 template< typename TYPENAME >
 inline const TYPENAME* /*const &*/ BinaryTree_Interface<TYPENAME>::constLeftChild() const
 { 
    return leftChild_Ptr;
 }
 
 /**
  * constRightChild() returns a constant reference to the right child pointer in this binary tree interface.
  *
  * @return const TYPENAME* const &
  */
 template< typename TYPENAME >
 inline const TYPENAME* /*const &*/ BinaryTree_Interface<TYPENAME>::constRightChild() const
 { 
    return rightChild_Ptr; 
 }
 
 /**
  * hasChild() returns true if this BinaryTree_Interface has at least one child; otherwise, false is returned.
  *
  * @return bool
  */
 template< typename TYPENAME >
 inline bool BinaryTree_Interface<TYPENAME>::hasChild() const
 {
    return leftChild_Ptr || rightChild_Ptr;
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // BINARYTREE_INTERFACE_H